#include <bits/stdc++.h>
using namespace std;
#define MAXFIN 1<<18 // unlike normal fenwick, this must be power of 2
typedef long long ll;

// coordinate compression
set<int> values;
map<int, int> v_to_c;
vector<int> c_to_v;

int MAXP = 0;
int n, p, the_k, A[200'000];
ll sum, best, low[MAXFIN][2], high[MAXFIN][2];

void add_s(ll fin[MAXFIN][2], int sign, int x, int val) {
  ll xval = val * sign * c_to_v[x];
  x = MAXP - x;
  fin[0][0] += val;
  fin[0][1] += xval;
  for (; x < MAXP; x += x & -x) {
    fin[x][0] += val;
    fin[x][1] += xval;
  }
}

ll sum_k(ll fin[MAXFIN][2], int sign) {
  if (the_k == 0) return 0;
  if (the_k >= fin[0][0]) return fin[0][1];
  int k = the_k;
  ll res = 0;
  int node = MAXP, range = MAXP;
  while (range > 1) {
    range /= 2;
    if (k < fin[node - range][0]) {
      node -= range;
    } else {
      k -= fin[node - range][0];
      res += fin[node - range][1];
    }
  }
  res += k * ll(c_to_v[MAXP-node]) * sign;
  return res;
}

void add(int val) {
  sum += val;
  if (val < 0) add_s(low, -1, v_to_c[-val], 1);
  if (val > 0) add_s(high, 1, v_to_c[val], 1);
}

void remove(int val) {
  sum -= val;
  if (val < 0) add_s(low, -1, v_to_c[-val], -1);
  if (val > 0) add_s(high, 1, v_to_c[val], -1);
}

int main() {
  scanf("%d%d%d", &n, &p, &the_k);
  if (p == 0) {
    printf("0\n");
    return 0;
  }
  char c;
  values.insert(0);
  for (int i = 0; i < n; ++i) {
    scanf(" %c %d", &c, A + i);
    values.insert(A[i]);
    if (c == 'Z') A[i] = -A[i];
  }
  int idx = 0;
  c_to_v.resize(values.size() + 2);
  for (auto v : values) {
    v_to_c[v] = idx;
    c_to_v[idx] = v;
    ++idx;
  }
  MAXP = 1<<5; 
  while (MAXP<idx+1) MAXP*=2;
  //fprintf(stderr, "%d\n", MAXP);
  for (int i = 0; i < n; ++i) {
    add(A[i]);
    if (i >= p) {
      remove(A[i - p]);
    }
    if (i >= p - 1) {
      best = max(best, sum - 2 * sum_k(low, -1));
      best = max(best, -sum + 2 * sum_k(high, 1));
    }
  }
  printf("%lld\n", best);
}
