from typing import Tuple, NamedTuple
import sys

# ============================ Set implemented as interval tree ==============================

class SegmentTree:
    def __init__(self):
        self.maxn = 2**10
        while self.maxn <= MAXV:
            self.maxn *= 2
        self.off = self.maxn
        self.maxn *= 2
        self.tree = [0] * (self.maxn * 2)
        self.sums = [0] * (self.maxn * 2)

    def sum(self) -> int:
        return self.sums[1] or 0

    def add(self, value: int, cnt: int):
        if K == 0: 
             self.sums[1] += value * cnt
             return
        x = vtc[value] + self.off + self.maxn
        while x > 0:
            self.tree[x] += cnt
            self.sums[x] += value * cnt
            x //= 2

    def smallest_k_neg(self) -> int:
        node = 2
        k = K
        if k == 0: return 0
        if k >= self.tree[node]: return self.sums[node]
        sum = 0
        while node < self.maxn:
            node = 2 * node
            if self.tree[node] < k:
                k -= self.tree[node]
                sum += self.sums[node]
                node += 1
        sum += k * ctv[node - self.maxn - self.off]
        return sum
    
    def largest_k_pos(self) -> int:
        node = 3
        k = K
        if k == 0: return 0
        if k >= self.tree[node]: return self.sums[node]
        sum = 0
        while node < self.maxn:
            node = 2 * node + 1
            if self.tree[node] < k:
                k -= self.tree[node]
                sum += self.sums[node]
                node -= 1
        sum += k * ctv[node - self.maxn - self.off]
        return sum

# ============================ The actual solution ==============================

N, P, K = [int(x) for x in sys.stdin.readline().split()]
D = []
values = set([0])
vtc = {}
ctv = {}

for n in range(N):
    smer, vzd = sys.stdin.readline().split()
    D.append(int(vzd) if smer == "V" else -int(vzd))
    values.add(int(vzd))

values = sorted(list(values))
for i, v in enumerate(values):
    vtc[v] = i
    vtc[-v] = -i
    ctv[i] = v
    ctv[-i] = -v
MAXV = len(values) + 2

if P == 0:
    print(0)
    quit(0)

S = SegmentTree()
best = 0

for i in range(N):
    S.add(D[i], 1)
    if i >= P:
        S.add(D[i - P], -1)
    if i >= P - 1:
        best = max(best, S.sum() - 2 * S.smallest_k_neg())
        best = max(best, -S.sum() + 2 * S.largest_k_pos())

print(best)
