from heapq import heappush, heappop

class Solver():
    def load(self):
        self.n, self.p, self.k = [ int(_) for _ in input().split() ]
        self.D = []
        for i in range(self.n):
            sm, vz = input().split()
            self.D.append( int(vz) * (-1 if sm == 'Z' else +1) )

    def init(self):
        self.answer = 0

    def add(self, i):
        x = self.D[i]
        self.s += x

        if x >= 0:
            heappush(self.B, (x, i))
            return

        self.z += x
        heappush(self.A, (-x, i))
        self.asize += 1
        self.inA[i] = True

        while self.asize > self.k:
            j = self.A[0][1]
            if self.lo <= j < self.hi:
                y = -self.A[0][0]
                self.z -= y
                self.asize -= 1
                self.inA[j] = False
                heappush(self.B, (y, j))
            heappop(self.A)

    def remove(self, i):
        x = self.D[i]
        self.s -= x

        if not self.inA[i]: return
        
        self.z -= x
        self.asize -= 1

        while self.asize < self.k:
            if self.B == []: break
            y, j = self.B[0]
            if y >= 0: break
            if self.lo <= j < self.hi:
                self.z += y
                self.asize += 1
                self.inA[j] = True
                heappush(self.A, (-y, j))
            heappop(self.B)

    def debug(self):
        print(f'currently examining range [ {self.lo}, {self.hi} ):', self.D[self.lo:self.hi])
        print(f'sum of range = {self.s}, sum to flip = {self.z}')
        print('A:', self.A)
        print(f'len(A):', self.asize)
        print('B:', self.B)
        print('inA:', self.inA)
        print()

    def solve_one(self):
        if self.p == 0: return 0
        self.s, self.z, self.asize = 0, 0, 0
        self.A, self.B = [], []
        self.inA = [ False ] * self.n
        self.lo, self.hi = 0, self.p
        for i in range(self.p): self.add(i)
        self.answer = max( self.answer, self.s - 2*self.z )
        # self.debug()
        for x in range(1, self.n-self.p+1):
            self.lo, self.hi = x, x+self.p
            self.add(x+self.p-1)
            self.remove(x-1)
            self.answer = max( self.answer, self.s - 2*self.z )
            # self.debug()
            
    def solve(self):
        self.load()
        self.init()
        self.solve_one()
        self.D = [ -d for d in self.D ]
        self.solve_one()
        return self.answer

solver = Solver()
print( solver.solve() )
